//SHARE-IN-MEMORY=true
// Copyright 2001, 2002, 2003 Macromedia, Inc. All rights reserved.

var outlineId = 1000;

function designerMgrTranslate(code, directives, useTable, displaySyntaxErrors)
{
	var translation = new Object();
	translation.string = "";
	translation.useMacRendering = 0;

	var result = ASPNetDesignerMgr.translate(code, directives);

	if (result[1]) // designer isn't available
	{
		translation.useMacRendering = 1;
	}
	else if (!result[1] && result[2]) // designer is available, but rejected this control
	{
		if (displaySyntaxErrors)
		{
			if (useTable)
				translation.string =
					"<table border=\"1\"><tr><td><MM_ASPNETSYNTAXERROR></td></tr></table>";
			else
				translation.string = "<MM_ASPNETSYNTAXERROR>";
		}
		else
		{
			translation.useMacRendering = 1;
		}
	}
	else
	{
		translation.string = result[0];
	}

	return translation;
}



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Function : getAttributeValue
// Purpose  : pull the ID attribute for the current tag
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function getAttributeValue(argNode, attrName)
{
  var attrValue;
  attrValue = argNode.getAttribute(attrName);
  if (!attrValue)
  {
		attrValue = "";	
  }
  return attrValue;
}


var configPath = null;
function getImage(name)
{
	if (configPath == null)
		configPath = dw.getConfigurationPath();
	return "<img src=\"" + configPath +
		"/ThirdPartyTags/ASPNetTags/" + name + "\">";
}


function getSubtag(node, subTagName, contentsOnly)
{
	var subTagContents="";
	if (node)
	{
		var childNodes = node.childNodes;
		for (var i= 0; i < childNodes.length;i++)
		{
			if (childNodes[i].tagName && 
				childNodes[i].tagName.toLowerCase() == subTagName)
			{
				if (contentsOnly)
				{
					subTagContents = childNodes[i].innerHTML;
				}
				else
				{
					subTagContents = childNodes[i].outerHTML;
				}
				break;
			}				
		}
	}
	return subTagContents;
}




// ===========================================================================
// BASIC CONTROLS
// ===========================================================================


// ----
// ASP:HyperLink
// ----
function translateHyperLink(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text != "")
				translation.string = "<a href=\"\">" + text + "</a>";
			else
			{
				var imageUrl = getAttributeValue(node, "imageurl");
				if (imageUrl != "")
					translation.string = "<a href=\"\"><img src=\"" + imageUrl + "\"/></a>";
				else
					translation.string = "<a href=\"\">[ASP:HYPERLINK]</a>";
			}
		}
		renderStr = translation.string;
	}
	return renderStr;
}



// ----
// ASP:Image
// ----
function translateImage(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var imageUrl = getAttributeValue(node, "imageurl");
			if (imageUrl != "")
				translation.string = "<img src=\"" + imageUrl + "\"/>";
			else
				translation.string = "[ASP:IMAGE]";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:Label
// ----
function translateLabel(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			// Perform manual translation
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = "[ASP:LABEL]";
			translation.string = "<span>" + text + "</span>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:Table
// ----
function translateTable(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			translation.string =
				"<table border=1>" +
				"<tr><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td></tr>" +
				"<tr><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td></tr>" +
				"<tr><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td><td>&nbsp; &nbsp;</td></tr>" +
				"</table>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:AdRotator
// ----
function translateAdRotator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
			translation.string = getImage("AdRotator.gif");
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:Calendar
// ----
function translateCalendar(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
			translation.string = getImage("Calendar.gif");
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:Literal
// ----
function translateLiteral(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text != "")
				translation.string = text;
			else
				translation.string = "[ASP:Literal]";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:Panel
// ----
function translatePanel(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var contents = node.innerHTML;
			if (contents != "")
				translation.string = "<div>" + contents + "</div>";
			else
				translation.string = "[ASP:Panel]";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:PlaceHolder
// ----
function translatePlaceHolder(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
			translation.string = "[ASP:PlaceHolder]";
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:Xml
// ----
function translateXml(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, false);
		// There's a problem with the designer class for Xml
		// If the designer rejects the control, we'll just use the Mac-style
		// rendering.
		if (translation.useMacRendering || translation.string == "")
			translation.string = "[ASP:XML]";
		renderStr = translation.string;
	}
	return renderStr;
}

// ===========================================================================
// VALIDATORS
// ===========================================================================

// ----
// ASP:CompareValidator
// ----
function translateCompareValidator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = getAttributeValue(node, "errormessage");
			if (text == "")
				text = "[ASP:COMPAREVALIDATOR]";
			translation.string = text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:CustomValidator
// ----
function translateCustomValidator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = getAttributeValue(node, "errormessage");
			if (text == "")
				text = "[ASP:CUSTOMVALIDATOR]";
			translation.string = text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:RangeValidator
// ----
function translateRangeValidator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = getAttributeValue(node, "errormessage");
			if (text == "")
				text = "[ASP:RANGEVALIDATOR]";
			translation.string = text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:RegularExpressionValidator
// ----
function translateRegularExpressionValidator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = getAttributeValue(node, "errormessage");
			if (text == "")
				text = "[ASP:REGULAREXPRESSIONVALIDATOR]";
			translation.string = text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:RequiredFieldValidator
// ----
function translateRequiredFieldValidator(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = getAttributeValue(node, "errormessage");
			if (text == "")
				text = "[ASP:REQUIREDFIELDVALIDATOR]";
			translation.string = text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:ValidationSummary
// ----
function translateValidationSummary(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, false);
		// There's a problem with the designer class for ValidationSummary.
		// If the designer rejects the control, we'll just use the Mac-style
		// rendering.
		if (translation.useMacRendering || translation.string == "")
			translation.string = "[ASP:VALIDATIONSUMMARY]";
		renderStr = translation.string;
	}
	return renderStr;
}




// ===========================================================================
// BASIC FORM ELEMENTS
// ===========================================================================

// ----
// ASP:Button
// ----

function translateButton(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text != "")
				translation.string = "<input type=\"submit\" value=\"" + text + "\">";
			else
				translation.string = "<input type=\"submit\" value=\"[ASP:BUTTON]\">";
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ----
// ASP:CheckBox
// ----
function translateCheckBox(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			var checkedAttr = "";
			if (getAttributeValue(node, "checked") == "true")
				checkedAttr = "checked";
			if (text == "" || text == "\"\"")
				text = "[ASP:CHECKBOX]";
			if (getAttributeValue(node, "textalign") == "left")
				translation.string = text + " <input type=\"checkbox\" " + checkedAttr + "/>";
			else
				translation.string = "<input type=\"checkbox\" " + checkedAttr + "/> " + text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:ImageButton
// ----
function translateImageButton(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var imageUrl = getAttributeValue(node, "imageurl");
			if (imageUrl != "")
				translation.string = "<input type=\"image\" border=\"0\" src=\"" + imageUrl + "\"/>";
			else
				translation.string = "[ASP:IMAGEBUTTON]";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:LinkButton
// ----
function translateLinkButton(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = "[ASP:LINKBUTTON]";
			translation.string = "<a href=\"\">" + text + "</a>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:RadioButton
// ----
function translateRadioButton(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = "[ASP:RADIOBUTTON]";
			var checkedAttr = "";
			if (getAttributeValue(node, "checked") == "true")
				checkedAttr = "checked";
			if (getAttributeValue(node, "textalign") == "left")
				translation.string = text + " <input type=\"radio\" " + checkedAttr + "/>";
			else
				translation.string = "<input type=\"radio\" " + checkedAttr + "/> " + text;
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:TextBox
// ----
function translateTextBox(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			var text = getAttributeValue(node, "text");
			if (text == "")
				text = "[ASP:TEXTBOX]";
			translation.string = "<input type=\"text\" value=\"" + text + "\"/>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}


// ===========================================================================
// DATABOUND FORM CONTROLS
// ===========================================================================

// ----
// ASP:CheckBoxList
// ----
function translateCheckBoxList(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			translation.string = "<table>" +
						"<tr><td width=50><input type=\"checkbox\">&nbsp;abc</td></tr>" +
						"<tr><td><input type=\"checkbox\"> abc</td></tr>" +
						"<tr><td><input type=\"checkbox\"> abc</td></tr>" +
						"</table>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:DropDownList
// ----
function translateDropDownList(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			translation.string = "<select>" +
						"<option selected>abc</option>" + 
						"</select>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:ListBox
// ----
function translateListBox(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			translation.string = "<select size=\"3\">" +
						"<option>abc</option>" + 
						"<option>abc</option>" + 
						"<option>abc</option>" + 
						"</select>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ----
// ASP:RadioButtonList
// ----
function translateRadioButtonList(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
		{
			translation.string = "<table>" +
						"<tr><td width=50><input type=\"radio\"/> abc</td></tr>" +
						"<tr><td><input type=\"radio\"/> abc</td></tr>" +
						"<tr><td><input type=\"radio\"/> abc</td></tr>" +
						"</table>";
		}
		renderStr = translation.string;
	}
	return renderStr;
}

// ===========================================================================
// DATABOUND CONTROLS
// ===========================================================================

// ----
// ASP:Repeater
// ----
function translateRepeater(node)
{
	var renderStr = "";
	return renderStr;
}

// ----
// ASP:DataGrid
// ----
function translateDataGrid(node)
{
	var renderStr="";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", true, true);
		var transString = new QuickString(translation.string);
		if (translation.useMacRendering)
		{
			transString.add("<table width=\"175\" border=\"1\">");
			transString.add("<tr>");
			transString.add("<td>Column0</td>");
			transString.add("<td>Column1</td>");
			transString.add("<td>Column2</td>");
			transString.add("</tr>");

			for (var i = 0; i < 6; i++)
			{
				transString.add("<tr><td>abc</td><td>abc</td><td>abc</td></tr>");
			}
			transString.add("</table>");
		}
		var firstTable = new RegExp("^<table", "i");
		transString = transString.toString().replace(firstTable, "<table mmTranslatedValueOutlineId=\"OUTLINEID=" + outlineId + "\" mmTranslatedValueOutline=\"OUTLINE=ASP:DataGrid\"");
		outlineId++;
		renderStr = transString;
	}
	return renderStr;
}


// ----
// ASP:DataList
// ----
function translateDataList(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", true, true);
		var transString = new QuickString(translation.string);
		if (translation.useMacRendering)
		{
			var item = getSubtag(node, "itemtemplate", true);
			if (item != "")
				item = "<tr><td>" + item + "</td></tr>";
			var header = getSubtag(node, "headertemplate", true);
			if (header != "")
				header = "<tr><td>" + header + "</td></tr>";
			var	footer = getSubtag(node, "footertemplate", true);
			if (footer != "")
				footer = "<tr><td>" + footer + "</td></tr>";
			var altItem = getSubtag(node, "alternatingitemtemplate", true);
			if (altItem != "")
				altItem = "<tr><td>" + altItem + "</td></tr>";
			var separator = getSubtag(node, "separatortemplate", true);
			if (separator != "")
				separator = "<tr><td>" + separator + "</td></tr>";

			transString.add("<table>");
			transString.add(header);

			if (separator != "" && altItem != "")
			{
				transString.add(item);
				transString.add(separator);
				transString.add(altItem);
				transString.add(separator);
				transString.add(item);
			}
			else if (separator != "")
			{
				transString.add(item);
				transString.add(separator);
				transString.add(item);
				transString.add(separator);
				transString.add(item);
			}
			else if (altItem != "")
			{
				transString.add(item);
				transString.add(altItem);
				transString.add(item);
				transString.add(altItem);
				transString.add(item);
			}
			else
			{
				transString.add(item);
				transString.add(item);
				transString.add(item);
				transString.add(item);
				transString.add(item);
			}

			if (footer != "")
			{
			  transString.add(footer);
			}
			
			transString.add("</table>");
		}
		var firstTable = new RegExp("^<table", "i");
		transString = transString.toString();
		if (transString.search(firstTable) != -1)
			transString = transString.replace(firstTable, "<table mmTranslatedValueOutlineId=\"OUTLINEID=" + outlineId + "\" mmTranslatedValueOutline=\"OUTLINE=ASP:DataList\"");
		else
			transString = "<table mmTranslatedValueOutlineId=\"OUTLINEID=" + outlineId + "\" mmTranslatedValueOutline=\"OUTLINE=ASP:DataList\"><tr><td>" + transString + "</td></tr></table>";
		outlineId++;
		renderStr = transString;
	}

	return renderStr;
}


// ===========================================================================
// GENERIC .NET CONTROL TRANSLATION
// ===========================================================================

function translateASPControl(node)
{
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var translation = designerMgrTranslate(code, "", false, true);
		if (translation.useMacRendering)
			translation.string = "<MM_ASPNETUNKNOWNTAG>";
		renderStr = translation.string;
	}
	return renderStr;
}

function translateCustomControl(node)
{
	// Ignore syntax errors for custom controls... it may be that the
	// control is valid, but doesn't have a designer.
	var renderStr = "";
	if (node)
	{
		var code = node.outerHTML;
		var dom = dw.getDocumentDOM();
		var directives = "";
		if (dom)
		{
			var documentStr = dom.documentElement.outerHTML;
			var registerRE = /<%@\s*register\s*[^>]*%>/ig;
			var registers = documentStr.match(registerRE);
			if (registers && registers.length > 0)
				directives = registers.join('');
		}
		var translation = designerMgrTranslate(code, directives, false, false);
		if (translation.useMacRendering)
			translation.string = "<MM_ASPNETUNKNOWNTAG>";
		renderStr = translation.string;
	}
	return renderStr;
}
